<?php
/**
 * Enqueue script and styles for child theme
 */
function woodmart_child_enqueue_styles() {
	wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'woodmart-style' ), woodmart_get_theme_info( 'Version' ) );
}
add_action( 'wp_enqueue_scripts', 'woodmart_child_enqueue_styles', 10010 );




add_filter( 'woocommerce_checkout_fields', 'custom_rename_checkout_labels' );
function custom_rename_checkout_labels( $fields ) {
    // Change le titre "Billing details"
    add_filter( 'woocommerce_checkout_billing_title', function() {
        return 'Informations de facturation';
    });
    return $fields;
}


add_filter( 'woocommerce_order_review_heading', 'custom_rename_your_order' );
function custom_rename_your_order( $heading ) {
    return 'Votre commande';
}

/**
 * Modifier les textes du checkout WooCommerce en franais
 */
// 1) Modifier le titre "Your order" (checkout - rcap commande)
add_filter( 'woocommerce_order_review_heading', 'stk_custom_order_heading' );
function stk_custom_order_heading( $heading ) {
    return 'Votre commande';
}

// 2) Modifier le titre "Billing details"
add_filter( 'gettext', 'stk_change_billing_details_text', 20, 3 );
function stk_change_billing_details_text( $translated_text, $text, $domain ) {
    // On cible exactement la chane et le domaine WooCommerce
    if ( 'woocommerce' === $domain ) {
        if ( 'Billing details' === $text ) {
            $translated_text = 'Dtails de facturation';
        }
        // si le template utilise "Billing details" chapp, on peut aussi tester $translated_text
        if ( 'Billing details' === $translated_text ) {
            $translated_text = 'Dtails de facturation';
        }
    }
    return $translated_text;
}

